/*
*******************************************************************************
*
* File:         pxgen.h
* Description:  
* Author:       Henrik Liebau
* Created:      05 Apr 2000
* Modified:     Thu Jul 26 08:48:07 2001 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxgen_H__
#define __pxgen_H__

/* include type definitions, if not already done */
#ifndef __pxgendef_H__
#include <pxgendef.h>
#endif /* defined __pxgendef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprInit 
 * CLI abbrev.: pprinit
 *
 * initializes PPR for the connected card and allocates necessary memory all
 * settings are put to default values. 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprInit ( 			/* @pprinit */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprDelete 
 * CLI abbrev.: pprdelete
 *
 * Frees all memory allocated closes down PPR for this card ( CAPI-X connection
 * is left opened) 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprDelete (			/* @pprdelete */
  bx_handletype handle);

/*----------------------------------------------------------------------------*
 * BestXPprProg 
 * CLI abbrev.: pprprog
 *
 * Programs the exerciser card with the current PPR settings. Requires the
 * Exerciser to be in stopped state. Generic properties BXPPR_USExxx
 * which parts are programmed. 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprProg (			/* @pprprog */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprGenDefaultSet 
 * CLI abbrev.: pprgendefaultset
 *
 * Set PPR Generic settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprGenDefaultSet (		/* @pprgendefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprGenSet/ 
 * CLI abbrev.: pprgenset prop=<genprop> value = <value>
 *
 * Set / Get PPR Generic settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprGenSet (			/* @pprgenset */
  bx_handletype handle,
  bxppr_gentype genprop,				/* @prop */
  bx_int32 value					/* @val */
  );
  
/*----------------------------------------------------------------------------*
 * BestXPprGenGet/ 
 * CLI abbrev.: pprgenget prop=<genprop>
 *
 * Get / Get PPR Generic settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprGenGet (			/* @pprgenget */
  bx_handletype handle,
  bxppr_gentype genprop,				/* @prop */
  bx_int32 * pValue					/* #RETURN "%lu" */
  );
  
/*---------------------------------------------------------------------------*
 * void EXPORT BestXPprVersion()
 *
 * Purpose	: get version of 
 *---------------------------------------------------------------------------*/
void EXPORT BestXPprVersion(bx_vertype * pVerInfo);

#ifdef PPRX_CALLBACK
/*---------------------------------------------------------------------------*
 * void EXPORT BestXPprCBSet (bx_handletype handle, bxppr_cbtype cbFct)
 *
 * Purpose	: set callback function
 *---------------------------------------------------------------------------*/
void EXPORT BestXPprCBSet (bx_handletype handle, bxppr_cbtype cbFct);
#endif /* defined PPRX_CALLBACK */

#ifdef __cplusplus
}
#endif

/* do not add code below this line */
#endif /* defined __pxgen_H__ */
